const fs = require('fs')

const clean = (file) => {
  fs.writeFileSync(file, JSON.stringify({}))
}

const getPlatform = () => {
  const args = process.argv.slice(2)
  if (args.includes('android')) {
    return 'android'
  } else if (args.includes('ios')) {
    return 'ios'
  }
  {
    return ''
  }
}

const hasBuildInfo = (file, path) => {
  const cacheFile = require(file)
  return Boolean(cacheFile[path])
}

const writeBuildInfo = (file, path, id) => {
  const cacheFile = require(file)
  cacheFile[path] = id
  fs.writeFileSync(file, JSON.stringify(cacheFile))
}

const getCacheFile = (file, path) => {
  const cacheFile = require(file)
  return cacheFile[path] || 0
}

const isPwdFile = (path) => {
  const cwd = __dirname.split('/').splice(-1, 1).toString()

  const pathArray = path.split('/')
  const map = new Map()
  const reverseMap = new Map()

  pathArray.forEach((it, indx) => {
    map.set(it, indx)
    reverseMap.set(indx, it)
  })

  if (pathArray.length - 2 == map.get(cwd)) {
    return reverseMap.get(pathArray.length - 1).replace(/\.js/, '')
  }

  return ''
}

const str2base64 = (str) => {
  const encode = encodeURI(str)
  return btoa(encode)
}

module.exports = {
  hasBuildInfo,
  writeBuildInfo,
  getCacheFile,
  clean,
  isPwdFile,
  getPlatform,
  str2base64
}
