import React, { useRef } from 'react'
import './reset.css'

const ScrollView = React.forwardRef((props: any, ref) => {
  const scrollViewRef = useRef<HTMLDivElement>(null)

  const scrollTo = ({ x = 0, y = 0 }: { x: number; y: number }) => {
    const dom = scrollViewRef.current as any
    dom?.scrollTo(x, y)
  }

  React.useImperativeHandle(ref, () => ({
    scrollTo
  }))

  return (
    <div className="woa-widget-scrollview" ref={scrollViewRef} style={props.style}>
      {props.children}
    </div>
  )
})

export default ScrollView
