import React from 'react'
import { useState, useEffect } from 'react'
import { StyleSheet, Animated, Easing, View, Text } from 'react-native'
import { mobileBorder } from '../../style/base'

const Loading = ({ isMobile, text }: { isMobile?: boolean; text?: string }) => {
  const [spinValue, setSpinValue] = useState(new Animated.Value(0))
  //旋转方法
  const spin = () => {
    setSpinValue((value) => {
      value.setValue(0)
      return value
    })
    Animated.timing(spinValue, {
      toValue: 1, // 最终值 为1，这里表示最大旋转 360度
      duration: 800,
      easing: Easing.linear,
      useNativeDriver: true
    }).start(() => spin())
  }
  useEffect(() => {
    // first
    spin()
    return () => {
      // second
    }
  }, [])

  // 映射 0-1的值 映射 成 0 - 360 度
  const spin1 = spinValue.interpolate({
    inputRange: [0, 1], //输入值
    outputRange: ['0deg', '360deg'] //输出值
  })
  return (
    <View style={[styles.wrap, isMobile ? mobileBorder : {}]}>
      <Animated.Image style={[styles.icon, { transform: [{ rotate: spin1 }] }]} source={require('../../assets/loading.png')} />
      {text && <Text style={[styles.text]}>{text}</Text>}
    </View>
  )
}

const styles = StyleSheet.create({
  wrap: {
    display: 'flex',
    height: '100%',
    width: '100%',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: '#fff',
    minHeight: 164
  },
  icon: {
    width: 24,
    height: 24
  },
  text: {
    fontSize: 16,
    lineHeight: 24,
    color: 'rgba(13, 13, 13, 0.66)',
    marginTop: 12
  }
})

export default Loading
