// Learn more https://docs.expo.io/guides/customizing-metro
const { getDefaultConfig } = require('@expo/metro-config')
const QRCode = require('qrcode')
const envInfo = require('./config/env.json')
const { str2base64 } = require('./util/index')
const ip = require('ip')

/** @type {import('expo/metro-config').MetroConfig} */
const config = getDefaultConfig(__dirname)

const DEFAULT_PORT = 8081

config.server.port = DEFAULT_PORT

const info = {
  name: str2base64(envInfo.block_type_id),
  url: str2base64(`${ip.address()}:${DEFAULT_PORT}`)
}

const query = new URLSearchParams(info)
const debugInfo = `https://www.xiezuo.local.rndebug?${query.toString()}`

QRCode.toString(debugInfo, { type: 'terminal', small: true }, function (err, url) {
  console.log(url)
})

// }
// config.serializer.processModuleFilter = module => {
//   //   !/node_modules\/(@?react-native|react)/.test(module.path)
//   return !/node_modules/.test(module.path)
// }

// config.serializer.createModuleIdFactory = () => {
//   return path => {
//     console.log(path, "createModuleIdFactory")
//     return path
//   }
// }

module.exports = config
