// Learn more https://docs.expo.io/guides/customizing-metro
const { getDefaultConfig } = require('@expo/metro-config')
const { hasBuildInfo, getCacheFile, getPlatform } = require('./util/index')
const path = require('path')

const bundleCommonInfoPath = path.join(__dirname, `./config/${getPlatform()}BundleCommonInfo.json`)

/** @type {import('expo/metro-config').MetroConfig} */
const config = getDefaultConfig(__dirname)

function processModuleFilter(module) {
  if (module['path'].indexOf('__prelude__') >= 0 || module['path'].indexOf('polyfills') >= 0) {
    return false
  }

  if (hasBuildInfo(bundleCommonInfoPath, module.path)) {
    return false
  }

  return true
}

// 不要使用 string 会导致 bundle 体积陡增
function createModuleIdFactory() {
  // 业务模块以 时间戳 来自增命名防止重复
  const fileToIdMap = new Map()
  let nextId = new Date().getTime()

  return (path) => {
    if (Boolean(getCacheFile(bundleCommonInfoPath, path))) {
      return getCacheFile(bundleCommonInfoPath, path)
    }

    let id = fileToIdMap.get(path)
    if (typeof id !== 'number') {
      id = nextId++
      fileToIdMap.set(path, id)
    }
    return id
  }
}

config.serializer.createModuleIdFactory = createModuleIdFactory
config.serializer.processModuleFilter = processModuleFilter

module.exports = config
