const { hasBuildInfo, writeBuildInfo, clean, getPlatform } = require('./util/index')
const path = require('path')

const bundleCommonInfoPath = path.join(__dirname, `./config/${getPlatform()}BundleCommonInfo.json`)

function createModuleIdFactory() {
  const fileToIdMap = new Map()
  let nextId = 0
  clean(bundleCommonInfoPath)

  return (_path) => {
    if (_path === path.join(__dirname, './node_modules/@babel/runtime/helpers/readOnlyError.js')) {
      return _path
    }
    let id = fileToIdMap.get(_path)

    if (typeof id !== 'number') {
      id = nextId++
      fileToIdMap.set(_path, id)

      !hasBuildInfo(bundleCommonInfoPath, _path) && writeBuildInfo(bundleCommonInfoPath, _path, fileToIdMap.get(_path))
    }

    return id
  }
}

module.exports = {
  serializer: {
    createModuleIdFactory // 给 bundle 一个id 避免冲突 cli 源码中这个id 是从1 开始 自增的
  }
}
