import Block from './src/Block'
import { AppRegistry, Text } from 'react-native'
import env from './config/env.json'

// 字体不跟随系统字体变化，统一修改Text组件属性默认值
interface TextWithDefaultProps extends Text {
  defaultProps?: { allowFontScaling?: boolean }
}

;(Text as unknown as TextWithDefaultProps).defaultProps = {
  ...((Text as unknown as TextWithDefaultProps).defaultProps || {}),
  allowFontScaling: false
}

AppRegistry.registerComponent(env.block_type_id, () => Block)
